/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import processing.core.PApplet;
import processing.sound.Analyzer;
import processing.sound.Engine;

public class PitchDetector
extends Analyzer {
    private final com.jsyn.unitgen.PitchDetector detector = new com.jsyn.unitgen.PitchDetector();
    private float minimumConfidence;

    public PitchDetector(PApplet pApplet, float f) {
        super(pApplet);
        this.minimumConfidence = f;
    }

    public PitchDetector(PApplet pApplet) {
        this(pApplet, 0.8f);
    }

    @Override
    protected void removeInput() {
        this.input = null;
    }

    @Override
    protected void setInput(UnitOutputPort unitOutputPort) {
        Engine.getEngine().add((UnitGenerator)this.detector);
        this.detector.start();
        this.detector.input.connect(unitOutputPort);
    }

    public float analyze() {
        return this.analyze(this.minimumConfidence);
    }

    public float analyze(float f) {
        return (float)(this.detector.confidence.getValue() >= (double)f ? this.detector.frequency.getValue() : 0.0);
    }

    public float analyze(float[] fArray) {
        fArray[0] = (float)this.detector.frequency.getValue();
        fArray[1] = (float)this.detector.confidence.getValue();
        return fArray[1] >= this.minimumConfidence ? fArray[0] : 0.0f;
    }
}

