/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitFilter;
import com.jsyn.unitgen.UnitGenerator;
import processing.core.PApplet;
import processing.sound.Effect;
import processing.sound.Engine;
import processing.sound.JSynCircuit;

public abstract class SoundObject {
    protected JSynCircuit circuit;
    protected UnitInputPort amplitude;
    protected float amp = 1.0f;
    protected boolean isPlaying = false;

    protected SoundObject(PApplet pApplet) {
        Engine.getEngine(pApplet);
    }

    private void setAmplitude() {
        this.amplitude.set((double)this.amp);
    }

    public void add(float f) {
        if (this.circuit.processor == null) {
            Engine.printError("stereo sound sources do not support adding");
        } else {
            this.circuit.processor.add(f);
        }
    }

    public void amp(float f) {
        this.amp = f;
        this.setAmplitude();
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void pan(float f) {
        if (this.circuit.processor == null) {
            Engine.printError("stereo sound sources do not support panning");
        } else if (Engine.checkPan(f)) {
            this.circuit.processor.pan(f);
        }
    }

    public void play() {
        if (!this.isPlaying) {
            Engine.getEngine().play(this.circuit);
            this.setAmplitude();
            this.isPlaying = true;
        }
    }

    public void stop() {
        this.isPlaying = false;
        this.amplitude.set(0.0);
        if (this.circuit.effect != null) {
            this.removeEffect(this.circuit.effect);
        }
        Engine.getEngine().stop(this.circuit);
    }

    public int channels() {
        return 1;
    }

    protected void setEffect(Effect<? extends UnitFilter> effect) {
        if (this.circuit.effect == effect) {
            Engine.printWarning("this effect is already processing the given sound source");
        } else {
            if (this.circuit.effect != null) {
                this.removeEffect(this.circuit.effect);
            }
            Engine.getEngine().add((UnitGenerator)effect.left);
            Engine.getEngine().add((UnitGenerator)effect.right);
            this.circuit.setEffect(effect);
        }
    }

    protected void removeEffect(Effect<? extends UnitFilter> effect) {
        if (this.circuit.effect != effect) {
            Engine.printError("this effect is not currently processing any signals.");
        } else {
            this.circuit.removeEffect();
        }
    }

    public JSynCircuit getUnitGenerator() {
        return this.circuit;
    }
}

