/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.HammingWindow;
import com.jsyn.data.HannWindow;

public class SpectralWindowFactory {
    private static final int NUM_WINDOWS = 16;
    private static final int MIN_SIZE_LOG_2 = 2;
    private static HammingWindow[] hammingWindows = new HammingWindow[16];
    private static HannWindow[] hannWindows = new HannWindow[16];

    public static HammingWindow getHammingWindow(int sizeLog2) {
        int index = sizeLog2 - 2;
        if (hammingWindows[index] == null) {
            SpectralWindowFactory.hammingWindows[index] = new HammingWindow(1 << sizeLog2);
        }
        return hammingWindows[index];
    }

    public static HannWindow getHannWindow(int sizeLog2) {
        int index = sizeLog2 - 2;
        if (hannWindows[index] == null) {
            SpectralWindowFactory.hannWindows[index] = new HannWindow(1 << sizeLog2);
        }
        return hannWindows[index];
    }
}

