/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitFilter;

public class ExponentialRamp
extends UnitFilter {
    public UnitInputPort time = new UnitInputPort("Time");
    public UnitVariablePort current;
    private double target;
    private double timeHeld = 0.0;
    private double scaler = 1.0;
    private double MIN_VALUE = 1.0E-5;

    public ExponentialRamp() {
        this.addPort(this.time);
        this.input.setup(this.MIN_VALUE, 1.0, 1.0);
        this.current = new UnitVariablePort("Current", 1.0);
        this.addPort(this.current);
    }

    @Override
    public void generate(int start, int limit) {
        double[] outputs = this.output.getValues();
        double currentInput = this.input.getValues()[0];
        double currentTime = this.time.getValues()[0];
        double currentValue = this.current.getValue();
        currentInput = Math.max(this.MIN_VALUE, currentInput);
        currentValue = Math.max(this.MIN_VALUE, currentValue);
        if (currentTime != this.timeHeld) {
            this.scaler = this.convertTimeToExponentialScaler(currentTime, currentValue, currentInput);
            this.timeHeld = currentTime;
        }
        if (currentInput != this.target) {
            this.scaler = this.convertTimeToExponentialScaler(currentTime, currentValue, currentInput);
            this.target = currentInput;
        }
        if (currentValue < this.target) {
            for (int i = start; i < limit; ++i) {
                if ((currentValue *= this.scaler) > this.target) {
                    currentValue = this.target;
                    this.scaler = 1.0;
                }
                outputs[i] = currentValue;
            }
        } else if (currentValue > this.target) {
            for (int i = start; i < limit; ++i) {
                if ((currentValue *= this.scaler) < this.target) {
                    currentValue = this.target;
                    this.scaler = 1.0;
                }
                outputs[i] = currentValue;
            }
        } else if (currentValue == this.target) {
            for (int i = start; i < limit; ++i) {
                outputs[i] = this.target;
            }
        }
        this.current.setValue(currentValue);
    }

    private double convertTimeToExponentialScaler(double duration, double source, double target) {
        double numFrames = duration * (double)this.getFrameRate();
        return Math.pow(target / source, 1.0 / numFrames);
    }
}

