/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.dsp.SimpleDelay;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitFilter;

public class MultiTapDelay
extends UnitFilter {
    public UnitInputPort preDelayMillis;
    private final int mMaxPreDelayFrames;
    private SimpleDelay mPreDelay;
    private SimpleDelay mDelay;
    private final int[] mPositions;
    private final float[] mGains;
    private int mPreDelayFrames = 0;

    public MultiTapDelay(int[] positions, float[] gains, int maxPreDelayFrames) {
        this.mPositions = positions;
        this.mGains = gains;
        this.preDelayMillis = new UnitInputPort("PreDelayMillis");
        double maxMillis = (double)maxPreDelayFrames * 1000.0 / 44100.0;
        this.preDelayMillis.setup(0.0, Math.min(10.0, maxMillis), maxMillis);
        this.addPort(this.preDelayMillis);
        this.mMaxPreDelayFrames = Math.max(1, maxPreDelayFrames);
        this.mPreDelay = new SimpleDelay(maxPreDelayFrames);
        int maxPosition = 0;
        for (int position : positions) {
            maxPosition = Math.max(maxPosition, position);
        }
        this.mDelay = new SimpleDelay(maxPosition);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] outputs = this.output.getValues();
        double preDelayMS = this.preDelayMillis.getValues()[0];
        int preDelayFrames = (int)(preDelayMS * 0.001 * (double)this.getFrameRate());
        preDelayFrames = Math.max(1, Math.min(this.mMaxPreDelayFrames, preDelayFrames));
        for (int i = start; i < limit; ++i) {
            this.mPreDelay.write((float)inputs[i]);
            this.mDelay.write(this.mPreDelay.read(preDelayFrames));
            this.mPreDelay.advance();
            double sum = 0.0;
            for (int tap = 0; tap < this.mPositions.length; ++tap) {
                sum += (double)(this.mDelay.read(this.mPositions[tap]) * this.mGains[tap]);
            }
            this.mDelay.advance();
            outputs[i] = sum;
        }
    }
}

