/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class Pan
extends UnitGenerator {
    public UnitInputPort input = new UnitInputPort("Input");
    public UnitInputPort pan;
    public UnitOutputPort output;

    public Pan() {
        this.addPort(this.input);
        this.pan = new UnitInputPort("Pan");
        this.addPort(this.pan);
        this.pan.setup(-1.0, 0.0, 1.0);
        this.output = new UnitOutputPort(2, "Output");
        this.addPort(this.output);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] panPtr = this.pan.getValues();
        double[] outputs_0 = this.output.getValues(0);
        double[] outputs_1 = this.output.getValues(1);
        for (int i = start; i < limit; ++i) {
            double gainB = panPtr[i] * 0.5 + 0.5;
            double gainA = 1.0 - gainB;
            double inVal = inputs[i];
            outputs_0[i] = inVal * gainA;
            outputs_1[i] = inVal * gainB;
        }
    }
}

