/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.dsp.AllPassDelay;
import com.jsyn.dsp.SimpleDelay;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.util.PseudoRandom;

public class PlateReverb
extends UnitGenerator {
    public UnitInputPort input;
    public UnitInputPort time;
    public UnitInputPort damping;
    public UnitOutputPort output;
    private static final double MAX_DECAY = 0.98;
    private static final float DECAY_DIFFUSION_1 = 0.7f;
    private static final float DECAY_DIFFUSION_2 = 0.5f;
    private static final float INPUT_DIFFUSION_1 = 0.75f;
    private static final float INPUT_DIFFUSION_2 = 0.625f;
    private static final float DAMPING = 0.5f;
    private static final float BANDWIDTH = 0.99995f;
    private float mDecay;
    private float mLeftFeedback;
    private float mRightFeedback;
    private double mSize = 1.0;
    private double mPreviousTime = -1.0;
    private OnePoleLowPassFilter mBandwidthLowPass = new OnePoleLowPassFilter(0.99995f);
    private AllPassDelay mDiffusion1 = new AllPassDelay(142, 0.75f);
    private AllPassDelay mDiffusion2 = new AllPassDelay(107, 0.75f);
    private AllPassDelay mDiffusion3 = new AllPassDelay(379, 0.625f);
    private AllPassDelay mDiffusion4 = new AllPassDelay(277, 0.625f);
    private ReverbSide mLeftSide;
    private ReverbSide mRightSide;

    public PlateReverb() {
        this(1.0);
    }

    public PlateReverb(double size) {
        this.input = new UnitInputPort("Input");
        this.addPort(this.input);
        this.mSize = size = Math.max(0.05, Math.min(5.0, size));
        this.time = new UnitInputPort("Time");
        this.addPort(this.time);
        this.time.setup(0.01, 2.0, 30.0);
        this.damping = new UnitInputPort("Damping");
        this.addPort(this.damping);
        this.damping.setup(1.0E-4, 0.5, 1.0);
        this.output = new UnitOutputPort(2, "Output");
        this.addPort(this.output);
        int[] zs = new int[]{149, 107, 379, 277, 677, 4453, 1801, 3727, 911, 4217, 2657, 3169};
        this.mDiffusion1 = new AllPassDelay((int)((double)zs[0] * size), 0.75f);
        this.mDiffusion2 = new AllPassDelay((int)((double)zs[1] * size), 0.75f);
        this.mDiffusion3 = new AllPassDelay((int)((double)zs[2] * size), 0.625f);
        this.mDiffusion4 = new AllPassDelay((int)((double)zs[3] * size), 0.625f);
        this.mLeftSide = new ReverbSide((int)((double)zs[4] * size), (int)((double)zs[5] * size), (int)((double)zs[6] * size), (int)((double)zs[7] * size));
        this.mRightSide = new ReverbSide((int)((double)zs[8] * size), (int)((double)zs[9] * size), (int)((double)zs[10] * size), (int)((double)zs[11] * size));
        this.mLeftSide.setFrequency(0.7f, 44100.0f);
        this.mRightSide.setFrequency(1.2f, 44100.0f);
    }

    private void process(float x) {
        x = this.mBandwidthLowPass.process(x);
        x = this.mDiffusion1.process(x);
        x = this.mDiffusion2.process(x);
        x = this.mDiffusion3.process(x);
        x = this.mDiffusion4.process(x);
        float leftSum = x + this.mRightFeedback;
        this.mLeftFeedback = this.mLeftSide.process(leftSum);
        float rightSum = x + this.mLeftFeedback;
        this.mRightFeedback = this.mRightSide.process(rightSum);
    }

    private double convertTimeToDecay(double size, double time) {
        double exponent = (0.52 - time / size) / 4.7;
        double square = 1.001 - Math.exp(exponent);
        double decay = Math.sqrt(Math.max(0.0, square));
        return Math.min(0.98, decay);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] leftOutputs = this.output.getValues(0);
        double[] rightOutputs = this.output.getValues(1);
        double timeValue = (float)this.time.getValues()[0];
        if (timeValue != this.mPreviousTime) {
            this.mDecay = (float)this.convertTimeToDecay(this.mSize, timeValue);
            this.mPreviousTime = timeValue;
        }
        float dampingValue = (float)this.damping.getValues()[0];
        this.mLeftSide.setDamping(dampingValue);
        this.mRightSide.setDamping(dampingValue);
        for (int i = start; i < limit; ++i) {
            this.process((float)inputs[i]);
            leftOutputs[i] = this.mLeftSide.getOutput();
            rightOutputs[i] = this.mRightSide.getOutput();
        }
    }

    private class ReverbSide {
        VariableAllPassDelay variableDelay;
        OnePoleLowPassFilter mLowPass = new OnePoleLowPassFilter(0.5f);
        SimpleDelay mDelay1;
        AllPassDelay mAllPassDelay;
        SimpleDelay mDelay2;
        private float outputScaler = 0.6f;
        private float mOutput;

        ReverbSide(int d1, int d2, int d3, int d4) {
            this.variableDelay = new VariableAllPassDelay(d1, -0.7f);
            this.mDelay1 = new SimpleDelay(d2);
            this.mAllPassDelay = new AllPassDelay(d3, 0.5f);
            this.mDelay2 = new SimpleDelay(d4);
        }

        public void setFrequency(float frequency, float sampleRate) {
            this.variableDelay.setFrequency(frequency, sampleRate);
        }

        private float process(float input) {
            float temp;
            this.mOutput = temp = this.variableDelay.process(input);
            temp = this.mDelay1.process(temp);
            this.mOutput -= temp;
            temp = this.mLowPass.process(temp);
            temp *= PlateReverb.this.mDecay;
            temp = this.mAllPassDelay.process(temp);
            this.mOutput += temp;
            temp = this.mDelay2.process(temp);
            this.mOutput -= (temp *= PlateReverb.this.mDecay);
            return temp;
        }

        private float getOutput() {
            return this.mOutput * this.outputScaler;
        }

        public void setDamping(float damping) {
            this.mLowPass.setCoefficient(1.0f - damping);
        }
    }

    private static class OnePoleLowPassFilter {
        private float mDelay;
        private float mCoefficient;

        OnePoleLowPassFilter(float coefficient) {
            this.mCoefficient = coefficient;
        }

        private float process(float input) {
            float output;
            this.mDelay = output = input * this.mCoefficient + this.mDelay * (1.0f - this.mCoefficient);
            return output;
        }

        public void setCoefficient(float coefficient) {
            this.mCoefficient = coefficient;
        }
    }

    private static class VariableAllPassDelay {
        RandomModulator mModulator = new RandomModulator();
        private float[] mBuffer;
        private int mLength;
        private int mCursor;
        private int mModulationDepth;
        private float mCoefficient = 0.65f;

        VariableAllPassDelay(int length, float coefficient) {
            this.mLength = length;
            this.mBuffer = new float[2 * length];
            this.mCoefficient = coefficient;
            this.setModulationDepth(40);
        }

        void setModulationDepth(int depthInFrames) {
            this.mModulationDepth = Math.min(depthInFrames, this.mLength / 3);
        }

        void setFrequency(float frequency, float sampleRate) {
            this.mModulator.setFrequency(frequency, sampleRate);
        }

        private float process(float input) {
            float x;
            int readCursor = this.mCursor - this.mLength;
            if ((readCursor += (int)(this.mModulator.generate() * (float)this.mModulationDepth)) < 0) {
                readCursor += this.mBuffer.length;
            }
            float z = this.mBuffer[readCursor];
            this.mBuffer[this.mCursor] = x = input - z * this.mCoefficient;
            ++this.mCursor;
            if (this.mCursor >= this.mBuffer.length) {
                this.mCursor = 0;
            }
            return z + x * this.mCoefficient;
        }
    }

    private static class RandomModulator {
        private PseudoRandom randomNum = new PseudoRandom();
        protected float prevNoise;
        protected float currNoise;
        private float mPhase;
        private float mPhaseIncrement;

        private RandomModulator() {
        }

        void setFrequency(float frequency, float sampleRate) {
            this.mPhaseIncrement = frequency / sampleRate;
        }

        public float generate() {
            this.mPhase += this.mPhaseIncrement;
            if ((double)this.mPhase > 1.0) {
                this.prevNoise = this.currNoise;
                this.currNoise = (float)this.randomNum.nextRandomDouble();
                this.mPhase = (float)((double)this.mPhase - 1.0);
            }
            return this.prevNoise + this.mPhase * (this.currNoise - this.prevNoise);
        }
    }

    private static class FastSineOscillator {
        private float mPhaseIncrement;
        private float mPhaseDelta;
        private float mPhase;
        private static final float PHASE_LIMIT = 1.5707964f;

        private FastSineOscillator() {
            this.mPhaseDelta = this.mPhaseIncrement = 1.0E-4f;
        }

        void setFrequency(float frequency, float sampleRate) {
            this.mPhaseIncrement = (float)((double)frequency * Math.PI / (double)sampleRate);
        }

        float generate() {
            this.mPhase += this.mPhaseDelta;
            if (this.mPhase > 1.5707964f) {
                this.mPhase = 1.5707964f - (this.mPhase - 1.5707964f);
                this.mPhaseDelta = -this.mPhaseIncrement;
            } else if (this.mPhase < -1.5707964f) {
                this.mPhase = -1.5707964f + (-1.5707964f - this.mPhase);
                this.mPhaseDelta = this.mPhaseIncrement;
            }
            float IF3 = 0.16666667f;
            float IF5 = 0.008333334f;
            float IF7 = 1.9841272E-4f;
            float IF9 = 2.755732E-6f;
            float IF11 = 2.505211E-8f;
            float x = this.mPhase;
            float x2 = x * x;
            return x * (x2 * (x2 * (x2 * (x2 * (x2 * -2.505211E-8f + 2.755732E-6f) - 1.9841272E-4f) + 0.008333334f) - 0.16666667f) + 1.0f);
        }
    }
}

