/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitFilter;

public class RangeConverter
extends UnitFilter {
    public UnitInputPort min = new UnitInputPort("Min", 40.0);
    public UnitInputPort max;

    public RangeConverter() {
        this.addPort(this.min);
        this.max = new UnitInputPort("Max", 2000.0);
        this.addPort(this.max);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] mins = this.min.getValues();
        double[] maxs = this.max.getValues();
        double[] outputs = this.output.getValues();
        for (int i = start; i < limit; ++i) {
            double low = mins[i];
            outputs[i] = low + (maxs[i] - low) * (inputs[i] + 1.0) * 0.5;
        }
    }
}

