/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.Synthesizer;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.Instrument;
import com.jsyn.util.VoiceOperation;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;

public class VoiceAllocator
implements Instrument {
    private int maxVoices;
    private VoiceTracker[] trackers;
    private long tick;
    private Synthesizer synthesizer;
    private static final int UNASSIGNED_PRESET = -1;
    private int mPresetIndex = -1;

    public VoiceAllocator(UnitVoice[] voices) {
        this.maxVoices = voices.length;
        this.trackers = new VoiceTracker[this.maxVoices];
        for (int i = 0; i < this.maxVoices; ++i) {
            this.trackers[i] = new VoiceTracker();
            this.trackers[i].voice = voices[i];
        }
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = this.trackers[0].voice.getUnitGenerator().getSynthesizer();
        }
        return this.synthesizer;
    }

    public int getVoiceCount() {
        return this.maxVoices;
    }

    private VoiceTracker findVoice(int tag) {
        for (VoiceTracker tracker : this.trackers) {
            if (tracker.tag != tag) continue;
            return tracker;
        }
        return null;
    }

    private VoiceTracker stealVoice() {
        VoiceTracker bestOff = null;
        VoiceTracker bestOn = null;
        for (VoiceTracker tracker : this.trackers) {
            if (tracker.voice == null) {
                return tracker;
            }
            if (bestOff != null) {
                if (tracker.on || tracker.when >= bestOff.when) continue;
                bestOff = tracker;
                continue;
            }
            if (tracker.on) {
                if (bestOn == null) {
                    bestOn = tracker;
                    continue;
                }
                if (tracker.when >= bestOn.when) continue;
                bestOn = tracker;
                continue;
            }
            bestOff = tracker;
        }
        if (bestOff != null) {
            return bestOff;
        }
        return bestOn;
    }

    protected synchronized UnitVoice allocate(int tag) {
        VoiceTracker tracker = this.allocateTracker(tag);
        return tracker.voice;
    }

    private VoiceTracker allocateTracker(int tag) {
        VoiceTracker tracker = this.findVoice(tag);
        if (tracker == null) {
            tracker = this.stealVoice();
        }
        tracker.tag = tag;
        tracker.when = this.tick++;
        tracker.on = true;
        return tracker;
    }

    protected synchronized boolean isOn(int tag) {
        VoiceTracker tracker = this.findVoice(tag);
        if (tracker != null) {
            return tracker.on;
        }
        return false;
    }

    protected synchronized UnitVoice off(int tag) {
        VoiceTracker tracker = this.findVoice(tag);
        if (tracker != null) {
            tracker.off();
            return tracker.voice;
        }
        return null;
    }

    @Override
    public void allNotesOff(TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                for (VoiceTracker tracker : VoiceAllocator.this.trackers) {
                    if (!tracker.on) continue;
                    tracker.voice.noteOff(VoiceAllocator.this.getSynthesizer().createTimeStamp());
                    tracker.off();
                }
            }
        });
    }

    @Override
    public void noteOn(final int tag, final double frequency, final double amplitude, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                VoiceTracker voiceTracker = VoiceAllocator.this.allocateTracker(tag);
                if (voiceTracker.presetIndex != VoiceAllocator.this.mPresetIndex) {
                    voiceTracker.voice.usePreset(VoiceAllocator.this.mPresetIndex);
                    voiceTracker.presetIndex = VoiceAllocator.this.mPresetIndex;
                }
                voiceTracker.voice.noteOn(frequency, amplitude, VoiceAllocator.this.getSynthesizer().createTimeStamp());
            }
        });
    }

    public void noteOn(final int tag, final double frequency, final double amplitude, final VoiceOperation operation, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                VoiceTracker voiceTracker = VoiceAllocator.this.allocateTracker(tag);
                operation.operate(voiceTracker.voice);
                voiceTracker.voice.noteOn(frequency, amplitude, VoiceAllocator.this.getSynthesizer().createTimeStamp());
            }
        });
    }

    @Override
    public void noteOff(final int tag, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                VoiceTracker voiceTracker = VoiceAllocator.this.findVoice(tag);
                if (voiceTracker != null) {
                    voiceTracker.voice.noteOff(VoiceAllocator.this.getSynthesizer().createTimeStamp());
                    VoiceAllocator.this.off(tag);
                }
            }
        });
    }

    @Override
    public void setPort(final int tag, final String portName, final double value, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                VoiceTracker voiceTracker = VoiceAllocator.this.findVoice(tag);
                if (voiceTracker != null) {
                    voiceTracker.voice.setPort(portName, value, VoiceAllocator.this.getSynthesizer().createTimeStamp());
                }
            }
        });
    }

    @Override
    public void usePreset(final int presetIndex, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                VoiceAllocator.this.mPresetIndex = presetIndex;
            }
        });
    }

    private class VoiceTracker {
        UnitVoice voice;
        int tag = -1;
        int presetIndex = -1;
        long when;
        boolean on;

        private VoiceTracker() {
        }

        public void off() {
            this.on = false;
            this.when = VoiceAllocator.this.tick++;
        }
    }
}

