/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

import com.softsynth.math.JustRatio;
import java.util.ArrayList;

public class PrimeFactors {
    private static final int SIEVE_SIZE = 1000;
    private static int[] primes;
    private final int[] factors;

    private static int[] primeListToArray(ArrayList<Integer> primeList) {
        int[] primes = new int[primeList.size()];
        for (int i = 0; i < primes.length; ++i) {
            primes[i] = primeList.get(i);
        }
        return primes;
    }

    public PrimeFactors(int[] factors) {
        this.factors = factors;
    }

    public PrimeFactors(int numerator, int denominator) {
        int[] topFactors = PrimeFactors.factor(numerator);
        int[] bottomFactors = PrimeFactors.factor(denominator);
        this.factors = PrimeFactors.subtract(topFactors, bottomFactors);
    }

    public PrimeFactors subtract(PrimeFactors pf) {
        return new PrimeFactors(PrimeFactors.subtract(this.factors, pf.factors));
    }

    public PrimeFactors add(PrimeFactors pf) {
        return new PrimeFactors(PrimeFactors.add(this.factors, pf.factors));
    }

    public static int[] subtract(int[] factorsA, int[] factorsB) {
        int i;
        int min;
        int max;
        if (factorsA.length > factorsB.length) {
            max = factorsA.length;
            min = factorsB.length;
        } else {
            min = factorsA.length;
            max = factorsB.length;
        }
        ArrayList<Integer> primeList = new ArrayList<Integer>();
        for (i = 0; i < min; ++i) {
            primeList.add(factorsA[i] - factorsB[i]);
        }
        if (factorsA.length > factorsB.length) {
            while (i < max) {
                primeList.add(factorsA[i]);
                ++i;
            }
        } else {
            while (i < max) {
                primeList.add(0 - factorsB[i]);
                ++i;
            }
        }
        PrimeFactors.trimPrimeList(primeList);
        return PrimeFactors.primeListToArray(primeList);
    }

    public static int[] add(int[] factorsA, int[] factorsB) {
        int i;
        int min;
        int max;
        if (factorsA.length > factorsB.length) {
            max = factorsA.length;
            min = factorsB.length;
        } else {
            min = factorsA.length;
            max = factorsB.length;
        }
        ArrayList<Integer> primeList = new ArrayList<Integer>();
        for (i = 0; i < min; ++i) {
            primeList.add(factorsA[i] + factorsB[i]);
        }
        if (factorsA.length > factorsB.length) {
            while (i < max) {
                primeList.add(factorsA[i]);
                ++i;
            }
        } else if (factorsB.length > factorsA.length) {
            while (i < max) {
                primeList.add(factorsB[i]);
                ++i;
            }
        }
        PrimeFactors.trimPrimeList(primeList);
        return PrimeFactors.primeListToArray(primeList);
    }

    private static void trimPrimeList(ArrayList<Integer> primeList) {
        for (int i = primeList.size() - 1; i >= 0 && primeList.get(i) == 0; --i) {
            primeList.remove(i);
        }
    }

    public static int[] factor(int n) {
        ArrayList<Integer> primeList = new ArrayList<Integer>();
        int i = 0;
        int p = primes[i];
        int exponent = 0;
        while (n > 1) {
            int d = n / p;
            int m = d * p;
            if (m == n) {
                n = d;
                ++exponent;
                continue;
            }
            primeList.add(exponent);
            exponent = 0;
            p = primes[++i];
        }
        if (exponent > 0) {
            primeList.add(exponent);
        }
        return PrimeFactors.primeListToArray(primeList);
    }

    public static int getPrime(int n) {
        return primes[n];
    }

    public static int getPrimeCount() {
        return primes.length;
    }

    public JustRatio getJustRatio() {
        long n = 1L;
        long d = 1L;
        for (int i = 0; i < this.factors.length; ++i) {
            int k;
            int exponent = this.factors[i];
            int p = primes[i];
            if (exponent > 0) {
                for (k = 0; k < exponent; ++k) {
                    n *= (long)p;
                }
                continue;
            }
            if (exponent >= 0) continue;
            exponent = 0 - exponent;
            for (k = 0; k < exponent; ++k) {
                d *= (long)p;
            }
        }
        return new JustRatio(n, d);
    }

    public int[] getFactors() {
        return (int[])this.factors.clone();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.printFactors(buffer, 1);
        buffer.append("/");
        this.printFactors(buffer, -1);
        return buffer.toString();
    }

    private void printFactors(StringBuffer buffer, int sign) {
        boolean gotSome = false;
        for (int i = 0; i < this.factors.length; ++i) {
            int pf = this.factors[i] * sign;
            if (pf <= 0) continue;
            if (gotSome) {
                buffer.append('*');
            }
            int prime = primes[i];
            if (pf == 1) {
                buffer.append("" + prime);
            } else if (pf == 2) {
                buffer.append(prime + "*" + prime);
            } else if (pf > 2) {
                buffer.append("(" + prime + "^" + pf + ")");
            }
            gotSome = true;
        }
        if (!gotSome) {
            buffer.append("1");
        }
    }

    static {
        boolean[] sieve = new boolean[1000];
        ArrayList<Integer> primeList = new ArrayList<Integer>();
        for (int i = 2; i < 500; ++i) {
            if (sieve[i]) continue;
            primeList.add(i);
            for (int multiple = 2 * i; multiple < 1000; multiple += i) {
                sieve[multiple] = true;
            }
        }
        primes = PrimeFactors.primeListToArray(primeList);
    }
}

